<?php

namespace App\Http\Controllers\Auth;

use App\Promotoria;
use App\Sucursales;
use App\Tramites;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;
use App\User;
use App\Role;
use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;

class UserController extends Controller {

    public function __construct() {

        $this->middleware('auth');
    }

    public function index(Request $request) {
        $sucursalId=0;
        if(Auth::user()->can('read-users')) {
            $sucursales = Sucursales::select('id','nombre')
                ->where('promotoria_id',Auth::user()->promotoria_id)
                ->where('status',1)
                ->get();

            if ($request->ajax()) {
                //dd($request);
                $users = User::select('id','firstname','lastname')
                    ->where('promotoria_id',Auth::user()->promotoria_id)
                    ->where(function ($query) use ($request) {
                        $query->where('firstname', 'LIKE', "%{$request->term}%")
                            ->orWhere('lastname', 'LIKE', "%{$request->term}%");
                    })
                ->get();
                return response()->json(['users' => $users ]);
            }

            if(Auth::user() ->can('manage-promotoria')){
                $users = User::with('roles')->  where('promotoria_id',Auth::user() -> promotoria_id)->get();
            }else{
                $users = User::whereHas('roles', function ($query) {
                    $query->whereDoesntHave('permissions', function ($query) {
                        $query->where('permissions.name','manage-promotoria');
                    });
                }) -> with('roles')->  where('promotoria_id',Auth::user() -> promotoria_id)->get();
            }

            return view('admin.user.index', compact('users', 'sucursales', 'sucursalId'));
        }
        return redirect('auth/logout');
    }

    public function create() {
            if (Auth::user()->can('create-users')) {
                $promotorias = Promotoria::all();
                $promotorias =  $promotorias->lists('razonSocial', 'id') -> all();
                $sucursales = Sucursales::where('promotoria_id',Auth::user() -> promotoria_id);
                $sucursales = $sucursales->lists('nombre', 'id');
                if(Auth::user() -> can('manage-promotoria')){
                    $roles = Role::orderBy('display_name', 'asc')->lists('display_name','id');
                }else{
                    $roles = Role::whereDoesntHave('permissions', function ($query) {
                        $query->where('permissions.name','manage-promotoria');
                    }) -> orderBy('display_name', 'asc')-> lists('display_name','id');
                }
                return view('admin.user.create', compact('roles', 'promotorias','sucursales'));
            }
            return redirect('auth/logout');
    }



    public function assign($id) {
            if (Auth::user()->can('assign-procedures')) {
                $user = User::findOrFail($id);
                $tramites = Tramites::where('promotoria_id',Auth::user() -> promotoria_id);
                $user_tramite = $user->tramites()->lists('tramite_id')->toArray();


                $tramites = $tramites->lists('nombre', 'id');
                return view('admin.user.assign', compact('tramites', 'user', 'user_tramite'));

            }
            return redirect('auth/logout');
    }


    public function assignPost(Request $request){
        $user = User::findOrFail($request -> input('id'));
        $procedures_id = $request -> input('procedures_id');
	if(empty($procedures_id))
		$procedures_id = array();
        $user -> tramites() -> sync($procedures_id);
        Session::flash('message', trans('ui.user.message_update', array('name' => $user->firstname)));
        if(Auth::user() ->can('manage-promotoria')){
            $users = User::with('roles')->  where('promotoria_id',Auth::user() -> promotoria_id)->get();
        }else{
            $users = User::whereHas('roles', function ($query) {
                $query->whereDoesntHave('permissions', function ($query) {
                    $query->where('permissions.name','manage-promotoria');
                });
            }) -> with('roles')->  where('promotoria_id',Auth::user() -> promotoria_id)->get();
        }
        return view('admin.user.index', compact('users'));

    }

    public function store(UserRequest $request) {
        if(Auth::user()->can('create-users')) {
            if(Auth::user() -> can('manage-promotoria'))
                $promotoria_id = $request -> input('promotoria_id');
            else
                $promotoria_id =  Auth::user() -> promotoria_id;

            $data = User::create([
                'firstname' =>  $request->input('firstname'),
                'lastname'  =>  $request->input('lastname'),
                'username'  =>  $request->input('username'),
                'email'     =>  $request->input('email'),
                'sucursal_id' => $request -> input('sucursal_id'),
                'promotoria_id'   => $promotoria_id,
                'password'  =>  \Hash::make($request->input('password')),
            ]);

            $user = User::findOrFail($data->id);

            $data->attachRoles(array($request->input('role_id')));

            Session::flash('message', trans('ui.user.message_create', array('name' => $user->firstname)));

            return redirect('auth/user/create');
        }

        return redirect('auth/logout');
    }

    public function edit($id) {
            if (Auth::user()->can('update-users')) {
                $promotorias = Promotoria::all();
                $promotorias =  $promotorias->lists('razonSocial', 'id') -> all();
                $sucursales = Sucursales::where('promotoria_id',Auth::user() -> promotoria_id);
                $sucursales = $sucursales->lists('nombre', 'id');
                $user = User::findOrFail($id);

                $roles_user = User::find($id)->roles()->lists('role_id')->toArray();
                if(Auth::user() -> can('manage-promotoria')){
                    $roles = Role::orderBy('display_name', 'asc')->lists('display_name','id');
                }else{
                    $roles = Role::whereDoesntHave('permissions', function ($query) {
                        $query->where('permissions.name','manage-promotoria');
                    }) -> orderBy('display_name', 'asc')-> lists('display_name','id');
                }
                return view('admin.user.edit', compact('user', 'roles', 'roles_user','promotorias','sucursales'));
            }

            return redirect('auth/logout');
    }

    public function update($id, UserRequest $request){
        if(Auth::user()->can('update-users')) {
            if(Auth::user() -> can('manage-promotoria'))
              $promotoria_id = $request -> input('promotoria_id');
            else
              $promotoria_id =  Auth::user() -> promotoria_id;
            $data = ! $request->has('password') ? $request->except('password') : array(
                'firstname' =>  $request->input('firstname'),
                'lastname'  =>  $request->input('lastname'),
                'username'  =>  $request->input('username'),
                'email'     =>  $request->input('email'),
                'promotoria_id' => $promotoria_id,
                'sucursal_id' => $request -> input('sucursal_id'),
                'password'  =>  \Hash::make($request->input('password')),
            );

            $user = User::findOrFail($id);

            $user->update($data);

            if($user->roles->count()) {

                $user->roles()->detach($user->roles()->lists('role_id')->toArray());
            }

            $user->attachRoles(array($request->input('role_id')));

            Session::flash('message', trans('ui.user.message_update', array('name' => $user->firstname)));

            return redirect('auth/user');
        }

        return redirect('auth/logout');
    }

    public function destroy($id) {
            if (Auth::user()->can('delete-users')) {

                $user = User::findOrFail($id);

                User::destroy($id);

                Session::flash('message', trans('ui.user.message_delete', array('name' => $user->firstname)));

                return redirect('auth/user');
            }

            return redirect('auth/logout');
    }

    public function show() {

        return view('admin.user.form_change_password');

    }

    public function changePassword(Request $request) {

        $this->validate($request, [
            'password' => 'required|confirmed|min:8',

        ]);

        $user = User::findOrFail(Auth::user()->id);

        $data = array(
            'password' => \Hash::make($request->input('password'))
        );

        $user->update($data);

        Session::flash('message', trans('ui.user.message_change_password'));

        return redirect('auth/user/change-password');
    }

    public function changePromotoria($id){
       $user =  User::find(Auth::user() -> id);
       $user -> promotoria_id = $id;
       $user -> save();
        return redirect('promotoria');
    }

    public function sucursalSeleted($id){
        $sucursalId= Sucursales::select('nombre')->where('id',$id)->get();
        //dd($sucursalId[0]->nombre);
        $sucursales = Sucursales::select('id','nombre')
            ->where('promotoria_id',Auth::user()->promotoria_id)
            ->where('status',1)
            ->get();

        $users = User::select('id','firstname','lastname','username','email')
            ->where('sucursal_id',$id)  -> get();

        return view('admin.user.index', compact('users', 'sucursales', 'sucursalId'));
    }

    public function getSucursales($id){

        return  Sucursales::select('id','nombre') ->where('promotoria_id',$id)  -> get();

    }
}
