<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Session;
use App\Promotoria;
use App\User;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\PromotoriaRequest;
use Illuminate\Support\Facades\Input;
class PromotoriaController extends Controller
{
    public function __construct() {

        $this->middleware('auth');
    }

    public  function index(){
        if(Auth::user() -> can('manage-promotoria')){
             $promotorias = Promotoria::all();
            return view('promotorias.promotorias',compact('promotorias'));
        }else{
            $promotoria = Promotoria::find(Auth::user() -> promotoria_id);
            if ($promotoria)
                return view('promotorias.index', compact('promotoria'));
            Session::flash('message', trans('ui.promotoria.message_create'));
            return view('promotorias.index');
        }


    }

    public function show($id){
        $promotoria = Promotoria::find($id);
        return view('promotorias.index', compact('promotoria'));

    }

    public function create(){

        if(Auth::user()->can('update-promotoria')) {
            return view('promotorias.create');
        }
        return redirect('auth/logout');


    }

    public function store(PromotoriaRequest $request){

            if(Auth::user()->can('update-promotoria')) {

            if($request -> hasFile('logo')){
                $logo = $request -> file('logo');

                $data = Promotoria::create([
                    'razonSocial' => $request -> input('razonSocial'),
                    'clave'       => $request -> input('clave'),
                    'logo'        =>  rand(11111, 99999).str_replace(' ', '',$logo -> getClientOriginalName()),
                    'dbConnection' => $request -> input('dbConnection'),
                    'username'     => $request -> input('username'),
                    'password' => $request -> input('password')
                ]);

                $request->file('logo')->move(
                    base_path() . '/public/images/promotoria/', $data -> logo
                );
            }else{
                Promotoria::create([
                    'razonSocial' => $request -> input('razonSocial'),
                    'clave'       => $request -> input('clave'),
                    'dbConnection' => $request -> input('dbConnection'),
                    'username'     => $request -> input('username'),
                    'password' => $request -> input('password')
                ]);
            }
            Session::flash('message', trans('ui.promotoria.message_update'));
            return redirect('promotoria');
        }
        return redirect('auth/logout');

    }


    public function edit($id){
            if (Auth::user()->can('update-promotoria')) {
                $promotoria = Promotoria::findOrFail($id);
                return view('promotorias.edit', compact('promotoria'));

            }
            return redirect('auth/logout');
    }

    public function update($id, PromotoriaRequest $request){
        if(Auth::user()->can('update-promotoria')) {
            $promotoria = Promotoria::findOrFail($id);
            if($request -> hasFile('logo')){
                $logo = $request -> file('logo');


                $data = ! $request->has('password') ?  array(
                    'razonSocial' => $request -> input('razonSocial'),
                    'clave'       => $request -> input('clave'),
                    'logo'        => rand(11111, 99999).str_replace(' ', '',$logo -> getClientOriginalName()),
                    'dbConnection' => $request -> input('dbConnection'),
                    'username'     => $request -> input('username'),
                )
                : array(
                    'razonSocial' => $request -> input('razonSocial'),
                    'clave'       => $request -> input('clave'),
                    'logo'        => rand(11111, 99999).str_replace(' ', '',$logo -> getClientOriginalName()),
                    'dbConnection' => $request -> input('dbConnection'),
                    'username'     => $request -> input('username'),
                    'password' => $request -> input('password')
                );

                if(file_exists( base_path() . '/public/images/promotoria/'. $promotoria -> logo))
             //       unlink(base_path() . '/public/images/promotoria/'. $promotoria -> logo);
                $promotoria = Promotoria::findOrFail($id);
                $promotoria -> update($data);



                $request->file('logo')->move(
                    base_path() . '/public/images/promotoria/', $promotoria-> logo
                );
            }else{
                $data = ! $request->has('password') ? $request->except('password') : array(
                    'razonSocial' => $request -> input('razonSocial'),
                    'clave'       => $request -> input('clave'),
                    'dbConnection' => $request -> input('dbConnection'),
                    'username'     => $request -> input('username'),
                    'password' => $request -> input('password')
                );
                $promotoria = Promotoria::findOrFail($id);
                $promotoria -> update($data);
            }

            Session::flash('message', trans('ui.promotoria.message_update'));
            return redirect('promotoria');

        }

        return redirect('auth/logout');
    }

    public function destroy($id){
        if(Auth::user()->can('manage-promotoria')) {
            if(Auth::user() -> promotoria_id == $id){
            $usuario = User::where('id',Auth::user() -> id) -> first();
            $cambio_promotoria = Promotoria::where('id','!=',$id) -> first();
            $usuario -> promotoria_id = $cambio_promotoria -> id;
            $usuario -> save();
            }
            $promotoria = Promotoria::findOrFail($id);
            Promotoria::destroy($id);
            Session::flash('message', trans('ui.promotoria.message_delete'));
            return redirect('promotoria');
        }
        return redirect('auth/logout');
    }




}
