<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Session;

use App\Reason;

class ReasonController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $reasons = Reason::all();
        return view('reasons.index', ['reasons' => $reasons, ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $reason = new Reason;
        $reason->name = $request->name;
        $reason->save();
        Session::flash('message', 'El motivo "'.$reason->name.'" ha sido creado satisfactoriamente.');
        return back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $reasons = Reason::find($id);
        return response()->json(['status' => 'OK', 'reason' => $reasons, ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $reason = Reason::find($id);
        $reason->name = $request->name;
        $reason->save();
        Session::flash('message', 'El motivo "'.$reason->name.'" ha sido actualizado satisfactoriamente.');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $reason = Reason::find($id);
        if ($reason) {
            $reason->delete();
            Session::flash('message', 'El motivo "'.$reason->name.'" ha sido eliminado satisfactoriamente.');
        } else {
            Session::flash('message', 'Ocurrió un error.');
        }
        return back();
    }
}
