<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use Illuminate\Support\Facades\Auth;

class TramiteRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nombre'       => 'required',
            'prefijo'      => 'required|max:3|unique:tramites,prefijo,'.$this -> id.',id,promotoria_id,'.Auth::user() -> promotoria_id,
            'payOrder' => 'required'
        ];
    }
}
