<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
class UserRequest extends FormRequest {

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if ($this->method() == 'POST')
        {
            // Update operation, exclude the record with id from the validation:
            $password_rule = 'required' . $this->get('id');
        }
        else
        {
            // Create operation. There is no id yet.
            $password_rule = '';
        }
        $id = $this -> id;
        return [
            'firstname' => 'required',
            'lastname' => 'required',
            'sucursal_id' => 'required',
            'username' => 'required|unique:user,username,'.$id,
            'email' => 'email|max:255|required|unique:user,email,'.$id,
            'password' => 'confirmed|'.$password_rule.'|min:8',
            'role_id' => 'required',
        ];
    }



}
