<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Registro extends Model
{
    protected $fillable = ['id', 'order_id', 'sucursal_id', 'tramite_id', 'date', 'service_time', 'dbConnection', 'user_id','policy_id'];
    protected $table = 'registros';
    public function agente()
    {
        return $this->belongsTo('App\User', 'user_id', 'id');
    }

    public function tramite()
    {
        return $this->belongsTo('App\Tramites', 'tramite_id', 'id');
    }

    public function servicios(){
        return $this->hasMany('App\RegistroServicio', 'record_id','order_id');
    }

    public function usuarios() {
        return $this->belongsToMany('App\User', 'user_records','record_id', 'user_id');
    }

    public function sucursal()
    {
        return $this->belongsTo('App\Sucursales','sucursal_id');
    }

}
