<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Sucursales extends Model
{
    protected $table = 'sucursales';

    protected $fillable = ['id', 'nombre', 'stt', 'status','promotoria_id'];

    public function ventanillas(){
        return $this->hasMany('App\Ventanillas', 'sucursal_id');
    }

    public function registros(){
        return $this->hasMany('App\Registro', 'sucursal_id');
    }

    public function tramites(){
        return $this->belongsToMany('App\Tramites', 'sucursal_tramites', 'sucursal_id', 'tramite_id');
    }
}
