<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPromotoriasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promotorias',function(Blueprint $table){
            $table->increments('id');
            $table->char('clave', 2)->unique();
            $table->string('razonSocial');
            $table->boolean('status')->default(true);
            $table->string('logo')->nullable();
            $table->string('dbConnection')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('promotorias');
    }
}
