<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddProceduresPivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sucursal_tramites', function (Blueprint $table) {
            $table->integer('sucursal_id')->unsigned();
            $table->integer('tramite_id')->unsigned();

            $table->foreign('sucursal_id')->references('id')->on('sucursales')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('tramite_id')->references('id')->on('tramites')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->primary(['sucursal_id', 'tramite_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
