<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDocumentsPivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

        public function up()
    {
        Schema::create('tramite_documentos', function (Blueprint $table) {
            $table->integer('documento_id')->unsigned();
            $table->integer('tramite_id')->unsigned();

            $table->foreign('documento_id')->references('id')->on('documentos')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('tramite_id')->references('id')->on('tramites')
                ->onUpdate('cascade')->onDelete('cascade');

            $table->primary(['documento_id', 'tramite_id']);
        });
    }

        /**
         * Reverse the migrations.
         *
         * @return void
         */

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
