<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registros',function(Blueprint $table){
            $table->increments('id');
            $table->integer('order_id');
            $table->integer('sucursal_id') -> unsigned();
            $table->integer('tramite_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->date('date');
            $table->time('service_time');
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('tramite_id')->references('id')->on('tramites')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('sucursal_id')->references('id')->on('sucursales')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('user')
                ->onUpdate('cascade')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
