<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class DatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        // $this->call(UserTableSeeder::class);
        $this->permissionsSeeder();
        $this->promotoriaSeeder();
        $this->sucursalSeeder();
        $this->rolesSeeder();
        $this->usersSeeder();
        Model::reguard();
    }



    private function permissionsSeeder(){
        DB::table('permissions')->insert(array(
            array('name'=> 'manage-promotoria','display_name'=>'Administrar Promotoría','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-records','display_name'=>'Leer registro de turnos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-permissions','display_name'=>'Leer Permisos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-permissions','display_name'=>'Crear Permisos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-permissions','display_name'=>'Modificar Permisos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-permissions','display_name'=>'Eliminar Permisos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-roles','display_name'=>'Leer Roles','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-roles','display_name'=>'Crear Roles','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-roles','display_name'=>'Modificar Roles','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-roles','display_name'=>'Eliminar Roles','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-users','display_name'=>'Leer Usuarios','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-users','display_name'=>'Crear Usuarios','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-users','display_name'=>'Modificar Usuarios','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-users','display_name'=>'Eliminar Usuarios','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-procedures','display_name'=>'Leer Tramites','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-procedures','display_name'=>'Crear Trámites','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-procedures','display_name'=>'Modificar Trámites','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-procedures','display_name'=>'Eliminar Trámites','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-documents','display_name'=>'Leer Documentos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-documents','display_name'=>'Crear Documentos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-documents','display_name'=>'Modificar Documentos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-documents','display_name'=>'Eliminar Documentos','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-branches','display_name'=>'Leer Sucursales','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-branches','display_name'=>'Crear Sucursales','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-branches','display_name'=>'Modificar Sucursales','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-branches','display_name'=>'Eliminar Sucursales','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'read-windows','display_name'=>'Leer Ventanillas','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'create-windows','display_name'=>'Crear Ventanillas','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-windows','display_name'=>'Modificar Ventanillas','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'delete-windows','display_name'=>'Eliminar Ventanillas','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'update-promotoria','display_name'=>'Modificar Promotoria','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'use-api-as-admin','display_name'=>'Acesso API como Administrador','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'use-api-as-agent','display_name'=>'Acesso API como Agente','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
            array('name'=> 'assign-procedures','display_name'=>'Asignar Trámites','created_at' => Carbon::now(),'updated_at' => Carbon::now()),
        ));
    }




    private function promotoriaSeeder(){
        DB::table('promotorias')->insert(
                array('clave'=> 'DEMO','razonSocial'=>'PROMOTORIA DEMO','status' => 1,'created_at' => Carbon::now(),'updated_at' => Carbon::now())
        );
    }
    private function sucursalSeeder(){
        DB::table('sucursales')->insert(
            array('nombre'=> 'DEMO','promotoria_id' => 1,'created_at' => Carbon::now(),'updated_at' => Carbon::now())
        );
    }

    private function rolesSeeder(){
        DB::table('roles')->insert(array(
                array('name'=> 'admin','display_name'=>'Administrador','promotoria_id' => 1,'created_at' => Carbon::now(),'updated_at' => Carbon::now())
        )

        );
        $permissions = \App\Permission::all();
        $permissions_id = $permissions -> lists('id');
        $roles = \App\Role::all();
        foreach($roles as $role){
            $role -> attachPermissions($permissions_id);
        }
    }

    private function usersSeeder(){
        DB::table('user')->insert(array(
            array(
                'firstname' => 'Saul',
                'lastname' => 'Martinez Flores',
                'username' => 'admin',
                'sucursal_id' => 1,
                'promotoria_id' => 1,
                'email' => 'saul@messoft.com',
                'password' => \Hash::make('admin'),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ),

        ));
        $user = \App\User::findOrFail(1);
        $user -> attachRoles(array(1));

    }

}
