
var $ajaxUrl = window.location.origin+'/public/api/v1/';


$(function(){
    $("#results").niceScroll();
});


$('#store-button').on('click', function () {
    var observations = $('#observacion-servicio').val()
    var clave = $('#servicio-select').val();
    var servicio = $('#servicio-select :selected').text();
    $.ajax({
        url: $ajaxUrl +'storeService?token='+$('#jwtoken').val(),
        type: 'POST',
        data:{
            'observations': observations,
            'servicio': servicio,
            'clave': clave,
            'record_id':$('#record_id').val()
        },
        beforeSend: function() {
            $("#store-button").html('<i  class="fa fa-circle-o-notch fa-spin"></i> ');
        },
        complete: function(data){


        },
        success: function(data){
            $("#store-button").switchClass('btn-primary','btn-success','slow',runAfterAnim);
            $("#store-button").html('<i  class="fa fa-check"></i> ');
            $('#observacion-servicio').val('');


        },
        error: function(data){
            $("#store-button").switchClass('btn-primary','btn-danger','slow',runAfterAnim);
            $("#store-button").html('<i  class="fa fa-times"></i> ');
            $('#observacion-servicio').val('');


        }
    });


});

function runAfterAnim(){
    $("#store-button").switchClass('btn-success','btn-primary','slow');
    $("#store-button").html('Guardar');
}



$('#search-button').on('click', function () {
    $.ajax({
        url: $ajaxUrl+'results?searchParameter='+$('#search-input').val()+'&token='+$('#jwtoken').val(),
        type: 'GET',
        success: function(data){
            $('#result-container').css('display','block');
            $('#results').html(data);
        },
        error: function(data){
            window.console.log(data);
        }
    });
});



$('#search-input').keypress(function(event){
    if(event.keyCode == 13){
        $('#search-button').click();
    }
});


function selectResult(poliza){
    $.ajax({
        url: $ajaxUrl+'cartera?policy='+poliza+'&token='+$('#jwtoken').val(),
        type: 'GET',
        beforeSend: function(){
            $('#contenedor-cartera').css('display','none');
            $('.windows8').css('display','block');
        },
        complete: function(){
            $('.windows8').css('display','none');
            $('#contenedor-cartera').css('display','block');

        },
        success: function(data){
            $("#poliza-label").html(poliza)
            $('#contenedor-cartera').html(data);
        },
        error: function(data){
            window.console.log(data);
        }
    });
}


function ocultarResultados(){
    $('#result-container').css('display','none');
}

function irDetalle(poliza,venta){
    $.ajax({
        url: $ajaxUrl+'detalle?policy='+poliza+'&token='+$('#jwtoken').val()+'&venta='+venta,
        type: 'GET',
        beforeSend: function(){
            $('#contenedor-cartera').css('display','none');
            $('.windows8').css('display','block');
        },
        complete: function(){
            $('.windows8').css('display','none');
            $('#contenedor-cartera').css('display','block');

        },
        success: function(data){
            $('#contenedor-cartera').html(data);
        },
        error: function(data){
            alert(data);
        }
    });
}


function irDetalleServicio(servicio){
    $.ajax({
        url: $ajaxUrl+"servicio/detalle?id_servicio="+servicio + '&token=' + $('#jwtoken').val(),
        type: "GET",

        success: function(data) {
            $('#detalleServicio-'+servicio).html(data);
        }
    }).done(function() {
    });

}

function irCartera(poliza){
    $.ajax({
        url: $ajaxUrl+'cartera?policy='+poliza+'&token='+$('#jwtoken').val(),
        type: 'GET',
        beforeSend: function(){
            $('#contenedor-cartera').css('display','none');
            $('.windows8').css('display','block');
        },
        complete: function(){
            $('.windows8').css('display','none');
            $('#contenedor-cartera').css('display','block');

        },
        success: function(data){
            $('#contenedor-cartera').html(data);
        },
        error: function(data){
            window.console.log(data);
        }
    });
}
