$(document).ready(function() {
    $('div.alert').not('.alert-important').delay(3000).fadeOut(350);
    var d = new Date();
    var day = d.getDate();
    var month = d.getMonth();
    var year = d.getFullYear();
    $('#dtpInicio').datetimepicker({
        format: 'DD/MM/YYYY',
        locale: 'es',
        defaultDate: new Date(year, month - 1, day)
    });
    $('#dtpFin').datetimepicker({
        format: 'DD/MM/YYYY',
        locale: 'es',
        defaultDate: new Date(year, month, day)
    });
});

$(document).on('click', '#btnExport', function(event) {
    $('#modalExportData').modal('toggle');
});


$(document).on('click', 'a.btn-mod-export', function(event) {
    event.preventDefault();
    $('#modalExportData #idSucursal').val(this.id);
    seedOption(this.id);
});

$(document).on('change', '#modalExportData #tipo', function(event) {
    event.preventDefault();
    if ($(this).val() == 'fecha') {
        $('#modalExportData .group-tramite').hide('400', function() {
            $('#modalExportData .group-date').show();
        });
    } else {
        $('#modalExportData .group-date').hide('400', function() {
            $('#modalExportData .group-tramite').show();
        });
    }
});

$(document).on('click', '#exportAll', function(event) {
    event.preventDefault();
    $('#modalExportData #idSucursal').val(-1);
    seedOption(this.id);
});

/**
 * Muestra las opciones de para seleccionar por tramite.
 */
function seedOption(id) {
    $.ajax({
        url: '/export/tramites/'+id,
    })
    .done(function(response) {
        var tramites = response.tramites;
        var options = $('#modalExportData #tramite');
        options.empty();
        $.each(tramites,function() {
            options.append($("<option />").val(this.id).text(this.nombre));
        });
    })
    .fail(function() {
    });
}
