<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="shortcut icon" href="#" type="{{ asset('images/favicon.ico') }}">
    <title>{{ trans('ui.title') }}</title>

    {!! Html::style('css/bootstrap.min.css') !!}
    {!! Html::style('css/style.css') !!}
    {!! Html::style('css/style-responsive.css') !!}
</head>
<body class="login-body">

<div class="container">
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif
    {!! Form::open(['method' => 'POST', 'url' => '/password/reset', 'class' => 'cmxform form-signin']) !!}
        <input type="hidden" name="token" value="{{ $token }}">
        <div class="form-signin-heading text-center">
            <h3 style="font-weight: bold; color: #7a7676">TURNOS <span class="text-muted">PRO</span></h3>
            <h4 style="font-weight: bold; color: #7a7676">Restablece tu contraseña</h4>
        </div>
        <div class="login-wrap">
            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                {!! Form::label('email', 'Email') !!}
                {!! Form::email('email', old('email'), ['class' => 'form-control', 'required' => 'required', 'placeholder' => 'eg: foo@bar.com']) !!}
                <small class="text-danger">{{ $errors->first('email') }}</small>
            </div>
            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                {!! Form::label('password', 'Nueva contraseña') !!}
                {!! Form::password('password', ['class' => 'form-control', 'required' => 'required']) !!}
                <small class="text-danger">{{ $errors->first('password') }}</small>
            </div>
            <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                {!! Form::label('password_confirmation', 'Confirma tu contraseña') !!}
                {!! Form::password('password_confirmation', ['class' => 'form-control', 'required' => 'required']) !!}
                <small class="text-danger">{{ $errors->first('password_confirmation') }}</small>
            </div>
            {!! Form::submit('Restablecer contraseña', ['class' => 'btn btn-primary btn-block']) !!}
        </div>

    {!! Form::close() !!}
</div>

@include('partials.script')
</body>
</html>
