@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    @stop


@section('content')
        <!--body wrapper start-->
    <div class="wrapper">
           @include('partials.message')
           <div class="row">
               <div class="col-sm-12">
                   <section class="panel">
                       <header class="panel-heading">
                             {{ trans('ui.documents.names') }}
                             <span class="tools pull-right">
                                <a href="javascript:;" class="fa fa-chevron-down"></a>
                             </span>
                       </header>
                       <div class="panel-body">
                           @if(Auth::user() -> can(['create-documents']))
                               <a href="{{ url('documento/create') }}" class="pull-right"><button class="btn btn-primary" type="button"><i class="fa fa-plus-circle"></i> {{ trans("ui.documents.button_add") }}</button></a>
                           @endif
                           <table class="display table table-bordered table-striped" id="dynamic-table">
                               <thead>
                                    <tr>
                                        <th>{{ trans('ui.documents.name') }}</th>
                                        @if(Auth::user()->can(['update-documents', 'delete-documents']))
                                            <th>{{ trans('ui.documents.operation_label') }}</th>
                                        @endif
                                    </tr>
                               </thead>
                               <tbody>
                               @foreach($documentos as $documento)
                                   <tr>
                                       <td>{{ $documento->nombre }}</td>
                                       @if(Auth::user()->can(['update-documents', 'delete-procedures']))
                                           <td>
                                                   @if(Auth::user()->can('update-documents'))
                                                       <a href="{{ url('documento/' . $documento->id . '/edit') }}">
                                                           <i class="fa fa-refresh"></i>
                                                       </a>
                                                   @endif

                                                   @if(Auth::user()->can('delete-documents'))
                                                           {!! Form::open(['url' => 'documento/'. $documento->id, 'method' => 'delete','style'=>'display:inline-block;']) !!}
                                                           <button class="delete-button" type="submit"><i class="fa fa-times-circle"></i></button>
                                                           {!! Form::close() !!}
                                                   @endif

                                           </td>
                                       @endif
                                   </tr>
                               @endforeach
                               </tbody>
                           </table>
                       </div>
                   </section>
               </div>
           </div>
    </div>
@stop

@section('script')
        <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    <script src="{{ asset('js/dynamic_table_init.js') }}"></script>
@stop
