@extends('layouts.master')
@section('style')
    <link href="{{ asset('js/advanced-datatable/css/demo_page.css') }}" rel="stylesheet" />
    <link href="{{ asset('js/advanced-datatable/css/demo_table.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('js/data-tables/DT_bootstrap.css') }}" />
    <link rel="stylesheet" href="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css')}}" />
    <link rel="stylesheet" href="{{asset('css/export.css')}}" />
    @stop


    @section('content')
            <!--body wrapper start-->
    <div class="wrapper">
        @include('partials.message')
        @include('partials.exportData')
        <div class="row">
            <div class="col-sm-12">
                <section class="panel">
                    <header class="panel-heading">
                        {{ trans('ui.record.names') }}
                        <span class="tools pull-right">
                            <a href="javascript:;" class="fa fa-chevron-down"></a>
                        </span>
                        @if($sucursal->registros->count() > 0)
                            <a href="#modalExportData" class="pull-right btn-mod-export" style="color:#535351;" data-toggle="modal" id="{{$sucursal->id}}">
                                Exportar {{$sucursal->registros->count()}} Registros <i class="fa fa-download" aria-hidden="true"></i>
                            </a>
                        @endif
                        <a href="{{ url('registro') }}" class="pull-right" style="margin:0px 15px; color:#535351;">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i> Regresar a la lista
                        </a>
                    </header>
                    <div class="panel-body">
                        <div class="panel-body">
                            <table class="display table table-bordered table-striped" id="dynamic-table" >
                                <thead>
                                <tr>
                                    <th>{{ trans('ui.record.procedure') }}</th>
                                    <th>{{ trans('ui.record.agent') }}</th>
                                    <th>{{ trans('ui.record.date') }}</th>
                                    <th>{{ trans('ui.record.service_time') }}</th>
                                    <th>{{ trans('ui.record.services') }}</th>
                                    <th>{{ trans('ui.documents.operation_label') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($registros as $registro)
                                    <tr>
                                    <td>{{ $registro -> tramite ->  nombre}}</td>
                                    <td><ul>
                                            @foreach($registro->usuarios as $usuario)
                                                <li>
                                                    {{ $usuario-> firstname. ' '. $usuario -> lastname }}
                                                </li>
                                            @endforeach
                                        </ul></td>
                                    <td>{{ $registro -> date }}</td>
                                    <td>{{ $registro->service_time }}</td>
                                    <td><ul>
                                            @foreach($registro->servicios()->where('sucursal_id',$registro->sucursal_id)->groupBy('servicio')->get() as $servicio)
                                                <li>
                                                    {{ $servicio->servicio }}
                                                </li>
                                            @endforeach
                                            {{-- @foreach($registro->servicios() -> where('sucursal_id',$registro -> sucursal_id) -> get() as $servicio)
                                                <li>
                                                    {{ $servicio-> servicio }}
                                                </li>
                                            @endforeach --}}
                                        </ul></td>
                                    <td>

                                        <a href="{{ url('registro/' . $registro->id ) }}">
                                            <i class="fa fa-eye"></i>
                                        </a>

                                    </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                            {!!$registros->render() !!}
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    @stop

    @section('script')
            <!--dynamic table-->
    <script type="text/javascript" language="javascript" src="{{ asset('js/advanced-datatable/js/jquery.dataTables.js')}}"></script>
    <script type="text/javascript" src="{{ asset('js/data-tables/DT_bootstrap.js') }}"></script>
    <!--dynamic table initialization -->
    {{-- <script src="{{ asset('js/dynamic_table_init.js') }}"></script> --}}

    {{-- The plugin datetimepicker --}}
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/min/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/eonasdan-bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('assets/bower_components/moment/locale/es.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/export.js')}}"></script>
    <script type="text/javascript">
        $(function () {
            // $('.input-group.date').datetimepicker({
            //     format: 'DD/MM/YYYY',
            //     locale: 'es'
            //     // pickTime: false,
            // });
        });
    </script>
@stop
